require( "quest/m1_petspa/convout.lua" );
combine_speech_tables();

function pet_spa_intro(flo)
	coroutine.yield(RESUME.ON_CLICK);
	coroutine.yield(RESUME.ON_MOUSE_NOT_DOWN);
	scene:DisplayFlash("flash/petspa_intro.swf");
	wait_subscene();
	game:Set("first_time_pet_spa", 1);
	complete_quest("check_with_walter");
	scene.WALTER:PlayAnim("ToBrush");
	wait_anim(scene.WALTER);
	scene.WALTER:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.WALTER:PlayAnim("DoStandE");
	flo:SetMode(MODE.FOLLOWCLICKS);
end;

function flo_conv(flo)
	flo:StartProc(MODE.CUTSCENE);
	if game:Get("seen_snookums") < 1 then		
		if game:Get("clicked_flo_pet_spa") < 1 then
			run_super_conversation("FLO", "quip_petspa_A");
			game:Set("clicked_flo_pet_spa", 1);
		else
			run_super_conversation("FLO", "quip_petspa_B");
		end
	else
		if game:Get("told_walter_about_snookums") < 1 then
			run_super_conversation(flo, "conv_saw_snookums_A");
			game:Set("told_walter_about_snookums", 1);
			add_quest("lure_snookums", false);
		elseif game:Get("given_snookums_to_walter") < 1 then
			run_super_conversation(flo, "conv_saw_snookums_B");
		elseif game:Get("given_dye_remover_to_walter") < 1 then
			if BAG_INV:CheckInventory("dyeremover") then
				run_super_conversation(flo, "conv_need_remover_A");
			else
				run_super_conversation(flo, "conv_need_remover_B");
			end
		elseif game:Get("asked_ethel_for_beads") > 0 and game:Get("got_wirecutters") < 1 then
			run_super_conversation(flo, "conv_walter_wire_cutters");
		else
			run_super_conversation(flo, "conv_walter_done");
		end
	end
	flo:StartProc(MODE.FOLLOWCLICKS);
end

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);	-- enable ground-based scaling
		actor:JumpToNamedPoint("florida");
		actor:FaceNow(DIR.W);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(flo_speed);
		actor:WalkTo("flo");
		wait_walkto();
		
		if game:Get("first_time_pet_spa") < 1 then
			actor:StartProc(pet_spa_intro);
		else
			if BAG_INV:CheckInventory("snookums") or (game:Get("given_snookums_to_walter") == 1 and game:Get("given_dye_remover_to_walter") < 1) then
				actor:Face(DIR.SE);
			end
			actor:SetMode(MODE.FOLLOWCLICKS);
		end
	end;
	
	on_arrive = function(flo, flo2)
		if BAG_INV:CheckInventory("snookums") == true then
			flo:StartProc(give_walter_snookums);
		else
			flo:StartProc(flo_conv);
		end
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

-- assumed this is called from a process that FLO is running
function walter_wash_snookums()
	scene.SNOOKUMS:SetAlpha(0);
	--scene.WASHTUB:PlayAnim("Anima");

	scene.WALTER:DumpAnimFile("anim/walter/stand");
	scene.WALTER:DumpAnimFile("anim/walter/talks");
	scene.WALTER:LoadAnimFile("anim/walter/wash_snookums");
	
	scene.WALTER:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.WALTER:PlayAnim("WashSnookums1");
	wait_anim(scene.WALTER);
	
	scene.DYE_REMOVER:SetAlpha(0);
	
	scene.WALTER:PlayAnim("WashSnookums2");
	wait_anim(scene.WALTER);
	
	scene.DYE_REMOVER:SetAlpha(1);
	
	scene.WALTER:PlayAnim("WashSnookums3");
	wait_anim(scene.WALTER);
	
	scene.SNOOKUMS:PlayAnim("SnookumsClean");
	scene.SNOOKUMS:SetAlpha(1);
	scene.WALTER:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.WALTER:PlayAnim("DoStandW");
end

function walter_conv(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("first_time_talked_to_walter") < 1 then
		run_super_conversation(flo, "conv_walter_shampoo");
		game:Set("first_time_talked_to_walter", 1);
	elseif game:Get("seen_snookums") < 1 then
		run_super_conversation(flo, "conv_goto_park");
	elseif game:Get("told_walter_about_snookums") < 1 then
		run_super_conversation(flo, "conv_saw_snookums_A");
		game:Set("told_walter_about_snookums", 1);
		add_quest("lure_snookums", false);
	elseif game:Get("given_snookums_to_walter") < 1 then
		run_super_conversation(flo, "conv_saw_snookums_B");
	elseif game:Get("given_dye_remover_to_walter") < 1 then
		if BAG_INV:CheckInventory("dyeremover") then
			run_super_conversation(flo, "conv_need_remover_A");
		else
			run_super_conversation(flo, "conv_need_remover_B");
		end
	elseif game:Get("asked_ethel_for_beads") > 0 and game:Get("got_wirecutters") < 1 then
		run_super_conversation(flo, "conv_walter_wire_cutters");
	else
		run_super_conversation(flo, "conv_walter_done");
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function give_walter_snookums(flo)
	flo:SetMode(MODE.CUTSCENE);
	BAG_INV:RemoveInventory("snookums");
	game:Set("told_walter_about_snookums", 1);
	game:Set("given_snookums_to_walter", 1);
	game:Set("seen_snookums", 1);
	if game:Get("given_dye_remover_to_walter") < 1 then
		run_super_conversation(flo, "conv_give_snookums_A");
	else
		delay(20);
		run_super_conversation(flo, "conv_give_snookums_B");
	end
	
	if quest_complete("bring_dye_to_petspa") then
		complete_quest("give_walter_snookums", false);
		complete_quest("find_snookums");
		game:EarnAward("avenue-flo_snookums");
		
		flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		flo:WalkTo("florida");
		wait_walkto();
		
		game:Set("just_completed_snookums", 1);
		goto_scene(flo, "m1_spendalot2");
	else
		complete_quest("give_walter_snookums");
		flo:SetMode(MODE.FOLLOWCLICKS);
	end
end;

function give_walter_dye_remover(flo)
	flo:SetMode(MODE.CUTSCENE);
	BAG_INV:RemoveInventory("dyeremover");
	game:Set("given_dye_remover_to_walter", 1);
	scene:Spawn(dye_remover_spec);
	if game:Get("given_snookums_to_walter") < 1 then
		run_super_conversation(flo, "conv_give_remover_A");
	else
		delay(20);
		run_super_conversation(flo, "conv_give_remover_B");
	end;
	
	if quest_complete("give_walter_snookums") then
		complete_quest("bring_dye_to_petspa", false);
		complete_quest("find_snookums");
		game:EarnAward("avenue-flo_snookums");
		
		flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		flo:WalkTo("florida");
		wait_walkto();
		
		game:Set("just_completed_snookums", 1);
		goto_scene(flo, "m1_spendalot2");
	else
		complete_quest("bring_dye_to_petspa");
		flo:SetMode(MODE.FOLLOWCLICKS);
	end
end;

walter_spec = 
{
	name = "WALTER";
	halo = "quest/objects/waltere";
	
	command = function(actor)
		prepare_actor_text(actor, walter_text_spec);
		--actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);	-- enable ground-based scaling
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(walter_speed);
		
		if game:Get("given_dye_remover_to_walter") > 0 then
			scene.WALTER:LastingEmotion();
			scene.WALTER:SetEmotion("clean");
		end
		
		if BAG_INV:CheckInventory("snookums") or (game:Get("given_snookums_to_walter") == 1 and game:Get("given_dye_remover_to_walter") < 1) then
			actor:JumpToNamedPoint("walter_snookums");
			actor:LoadAnimFile("anim/walter/stand_nobrush");
			--actor:LoadAnimFile("anim/walter/talks");
			actor:PlayAnim("DoStandE");
			actor:FaceNow(DIR.E);
		else
			if quest_complete("find_snookums") then
				actor:LoadAnimFile("anim/walter/stand_clean");
				actor:LoadAnimFile("anim/walter/talks_clean");
				actor:PlayAnim("DoStandE");
				actor:FaceNow(DIR.E);
			else
				actor:LoadAnimFile("anim/walter/stand");
				actor:LoadAnimFile("anim/walter/talks");
				actor:PlayAnim("DoStandE");
				actor:FaceNow(DIR.E);
			end
		
			actor:JumpToNamedPoint("walter");
			
			if game:Get("first_time_pet_spa") < 1 then
				actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
				actor:PlayAnim("IntroStand");
			end
		end
	end;
	
	on_arrive=  function(flo, walter)
		if BAG_INV:CheckInventory("snookums") == true then
			flo:StartProc(give_walter_snookums);
		else
			flo:StartProc(walter_conv);
		end
	end;
	
	on_use_inv = function(item, flo, walter)
		if item == "snookums" then
			flo:StartProc(give_walter_snookums);
			return RESPONSE.INV_HANDLED;
		elseif item == "dyeremover" then
			flo:StartProc(give_walter_dye_remover);
			return RESPONSE.INV_HANDLED;
		else
			return RESPONSE.INV_UNHANDLED;
		end
	end;
};

function dog_conv(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	-- initial setup
	if game:Get("petspa_dog_choice") == nil then
		game:Set("petspa_dog_choice", 1);
	end
	
	local choice = game:Get("petspa_dog_choice");
	
	if choice == 1 then
		run_super_conversation(flo, "quip_dog_A");
	elseif choice == 2 then
		run_super_conversation(flo, "quip_dog_B");
	else -- choice == 3
		run_super_conversation(flo, "quip_dog_C");
	end
	
	choice = choice + 1;
	
	if choice == 4 then
		choice = 1;
	end
	
	game:Set("petspa_dog_choice", choice);
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

dog_spec = 
{
	name = "DOG";
	halo = "quest/objects/petspadogw";
	gfx = { anim = "anim/petspadog/stand" };
	
	command = function(actor)
		prepare_actor_text(actor, petspadog_text_spec);
		--actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);	-- enable ground-based scaling
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		--actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		--actor:SetDepthValue(460);
		actor:SetWalkSpeed(petspadog_speed);
		actor:JumpToNamedPoint("dog");
		actor:FaceNow(DIR.E);
	end;
	
	on_arrive = function(flo, dog)
		flo:StartProc(dog_conv);
	end;
};

snookums_spec = 
{
	name = "SNOOKUMS";
	halo = "quest/objects/snookums";
	gfx = { anim = "anim/snookums/washtub" };
	
	command = function(actor)
		prepare_actor_text(actor, snookums_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		--actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);
		--actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetDepthMode(DEPTH.DEPTH_FRONTMOST);		-- depth by y
		actor:SetWalkSpeed(snookums_speed);
		actor:JumpToNamedPoint("snookums");
		actor:FaceNow(DIR.W);
		
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		actor:PlayAnim("SnookumsRed");
	end;
	
	on_arrive=  function(flo, snookums)
		convproc("FLO", "quip_look_at_snookum_petspa");
	end;
};

function gotoflorida(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:WalkTo("florida");
	wait_walkto();
	
	if game:Get("first_time_leave_pet_spa") < 1 and game:Get("given_dye_remover_to_walter") < 1 then
		run_super_conversation(flo, "conv_spa_leave");
		add_quest("need_dye_remover", false);
		add_quest("check_with_betty");
		wait_subscene();
		flo:Face(DIR.E);
		game:Set("first_time_leave_pet_spa", 1);
	end
	
	goto_scene(flo, "m1_spendalot2");
end

to_florida_spec = 
{
	name = "TO_FLORIDA";
	halo = "to_florida";
	cursor = "cursor_arrow_n";
	goto_fn = gotoflorida;
}

function getWirecutters(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("got_wirecutters") < 1 then
		scene.SOFA:PlayAnim("open");
		delay(30);
		if game:Get("asked_ethel_for_beads") > 0 then
			run_super_conversation(flo, "quip_cutters_A");
			complete_quest("need_wirecutters", false);
			add_quest("give_ethel_wirecutters");
		else
			run_super_conversation(flo, "quip_cutters_B");
		end
		
		scene.SOFA:PlayAnim("closed");
		addInventory(inv_desc_wirecutters);
		game:Set("got_wirecutters", 1);
		delay(30);
	else
		--scene.SOFA:PlayAnim("open");
		--delay(3);
		run_super_conversation(flo, "quip_cutters_C");
		--delay(30);
		--scene.SOFA:PlayAnim("closed");
	end
	
	flo:WalkTo("flo");
	wait_walkto();
	flo:Face(DIR.SW);
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

sofa_spec = 
{
	name = "SOFA";
	halo = "sofa";
	gfx = { anim = "anim/m1_petspa/sofa" };

	command = function(actor)
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		actor:SetDepthValue(50);
		actor:PlayAnim("closed");
	end;

	on_arrive = function(flo, actor)
		flo:FaceActor(actor);
		flo:StartProc(getWirecutters);
	end;
}

hydrant_spec = 
{
	name = "HYDRANT";
	halo = "hydrant";

	command = function(actor)
	end;

	on_arrive = function(flo)
		convproc("FLO", "quip_hydrant");
	end;
}

function lookat_cat1(flo)
	flo:SetMode(MODE.CUTSCENE);
	local cat_num = game:Get("petspa_looked_at_cat_1");
	
	if cat_num == nil then
		cat_num = 0;
	end
	
	run_super_conversation(flo, "quip_kitty_" .. string.char(string.byte("a") + cat_num));
	
	game:Set("petspa_looked_at_cat_1", fmod(cat_num + 1, 2));
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function lookat_cat2(flo)
	flo:SetMode(MODE.CUTSCENE);
	local cat_num = game:Get("petspa_looked_at_cat_2");
	
	if cat_num == nil then
		cat_num = 0;
	end
	
	run_super_conversation(flo, "quip_kitty_" .. string.char(string.byte("c") + cat_num));
	
	game:Set("petspa_looked_at_cat_2", fmod(cat_num + 1, 2));
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

cat1_spec = 
{
	name = "CAT_1";
	halo = "cat1";
	gfx = { anim = "anim/m1_petspa/cat1" };

	command = function(actor)
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		actor:PlayAnim("Idle");
		actor:SetDepthValue(49); --behind sofa
	end;

	on_arrive = function(flo)
		flo:StartProc(lookat_cat1);
	end;
}

cat2_spec = 
{
	name = "CAT_2";
	halo = "cat2";
	gfx = { anim = "anim/m1_petspa/cat2" };

	command = function(actor)
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		actor:PlayAnim("Idle");
		actor:SetDepthValue(51); -- in front of sofa
		actor:JumpToPoint{ x = -200, y = 30 };
	end;

	on_arrive = function(flo)
		flo:StartProc(lookat_cat2);
	end;
}

lamp_spec = 
{
	name = "LAMP";
	halo = "lamp";

	command = function(actor)
	end;

	on_arrive = function(flo)
		convproc("FLO", "quip_lamp");
	end;
}

picture1_spec = 
{
	name = "PICTURE1";
	halo = "picture1";

	command = function(actor)
	end;

	on_arrive = function(flo)
		convproc("FLO", "quip_picture_A");
	end;
}

picture2_spec = 
{
	name = "PICTURE2";
	halo = "picture2";

	command = function(actor)
	end;

	on_arrive = function(flo)
		convproc("FLO", "quip_picture_B");
	end;
}

function lookat_treats(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("looked_at_treats_in_pet_spa") < 1 then
		run_super_conversation(flo, "quip_treats_A");
		game:Set("looked_at_treats_in_pet_spa", 1);
	elseif not quest_added("need_dog_treats") then
		run_super_conversation(flo, "quip_treats_B");
		add_quest("need_dog_treats");
	else
		run_super_conversation(flo, "quip_treats_C");
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

treats_spec = 
{
	name = "TREATS";
	halo = "treats";

	command = function(actor)
	end;

	on_arrive = function(flo)
		flo:StartProc(lookat_treats);
	end;
}

washtub_spec = 
{
	name = "WASHTUB";
	gfx = { anim = "anim/m1_petspa/sink" };
	
	command = function(actor)
		actor:SetDepthValue(405);
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		
		if game:Get("given_snookums_to_walter") == 1 and game:Get("given_dye_remover_to_walter") < 1 then
			actor:PlayAnim("Anima");
			scene:Spawn(snookums_spec);
		else
			actor:PlayAnim("Anima");
		end
	end;
	
}

dye_remover_spec = 
{
	name = "DYE_REMOVER";
	gfx = { image = "dye_remover" };
	
	command = function(actor)
		actor:SetDepthValue(600);
	end;
}

sink_spec = 
{
	name = "SINK";
	halo = "sink";
	
	command = function(actor)
		actor:SetDepthValue(400);
	end;
	
	on_arrive = function(flo, actor)
		flo:StartProc(
			function(flo)
				flo:SetMode(MODE.CUTSCENE);
				flo:Face(DIR.E);
				delay(15);
				conv_multiple(flo, "quip_sink_", "A", 2);
				flo:Face(DIR.W);
				flo:SetMode(MODE.FOLLOWCLICKS);
			end
		)
	end;
}

bone_spec = 
{
	name = "BONE";
	halo = "bones";
	
	command = function(actor)
		actor:SetDepthValue(depth);
	end;
	
	on_arrive = function(flo, actor)
		flo:StartProc(
			function(flo)
				flo:SetMode(MODE.CUTSCENE);
				run_super_conversation(flo, "quip_bones");
				flo:SetMode(MODE.FOLLOWCLICKS);
			end
		)
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/petspamusic.ogg", true);
		scene:SetRoomScale(230, 500, 0.8, 1.0);	--topline, bottomline, topscale, bottomscale
		
		fade_scene_up();
		
		if IsCheatMode() then
			-- testing data
			--game:Set("asked_ethel_for_beads", 1);
			--game:Set("seen_snookums", 1);
			--BAG_INV:AddInventory(inv_desc_snookums);
			--BAG_INV:AddInventory(inv_desc_dyeremover);
			--add_quest("give_walter_snookums");
			---add_quest("bring_dye_to_petspa");
			--game:Set("given_dye_remover_to_walter", 1);
			--complete_quest("find_snookums")
		end
		
		spawn_nav_arrow(to_florida_spec);
		
		if game:Get("given_dye_remover_to_walter") > 0 then
			scene:Spawn(dye_remover_spec);
		end
		
		game:SetString("map_position", "m1_petspa");
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces" -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		{ "plant", 200 },
		{ "counter", 335 },
		{ "sink", 400 },
		{ "table1", 450 },
		{ "table2", 550 },
		{ "trolley", 550 },
		

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		flo_spec, -- the main actor
		walter_spec,
		dog_spec,
		sofa_spec,
		hydrant_spec,
		cat1_spec,
		cat2_spec,
		lamp_spec,
		picture1_spec,
		picture2_spec,
		treats_spec,
		washtub_spec,
		sink_spec,
		bone_spec,
		
		scene_setup,
	};
};
